/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.StoveBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StoveBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier,
WorldlyContainerHolder,
DropWithName {
    private final MetalType type;

    public StoveBlock(MetalType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape baseShape = Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        VoxelShape bottomShape = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape closedDoorShape = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0);
        VoxelShape openDoorShape = Block.m_49796_((double)-11.0, (double)1.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(List.of(topShape));
            shapes.add(VoxelShapeHelper.rotateHorizontally(baseShape, direction));
            shapes.add(VoxelShapeHelper.rotateHorizontally(bottomShape, direction));
            shapes.add(VoxelShapeHelper.rotateHorizontally(open ? openDoorShape : closedDoorShape, direction));
            return VoxelShapeHelper.combine(shapes);
        })));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Direction)state.m_61143_((Property)DIRECTION)).m_122424_() == result.m_82434_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof StoveBlockEntity) {
                StoveBlockEntity stove = (StoveBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)stove);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)blockEntity;
            stove.onDestroyed(pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbourPos, boolean movedByPiston) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, block, neighbourPos, movedByPiston);
        if (pos.m_7494_().equals((Object)neighbourPos) && (blockEntity = level.m_7702_(pos)) instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)blockEntity;
            stove.onNeighbourChanged();
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
        builder.m_61104_(new Property[]{POWERED});
        builder.m_61104_(new Property[]{LIT});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)blockEntity;
            stove.m_58638_(stack.m_41786_());
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Services.BLOCK_ENTITY.createStoveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.m_5776_()) {
            return StoveBlock.createTicker(type, (BlockEntityType)ModBlockEntities.STOVE.get(), StoveBlockEntity::serverTick);
        }
        return null;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_, BlockTags.f_144286_);
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor accessor, BlockPos pos) {
        BlockEntity blockEntity = accessor.m_7702_(pos);
        if (blockEntity instanceof StoveBlockEntity) {
            StoveBlockEntity stove = (StoveBlockEntity)blockEntity;
            return stove.getContainer();
        }
        return null;
    }
}

